% ------------------------------------------------------------------------
% Script: infile_1d
% ------------------------------------------------------------------------
% Aim: 
% one example of infile.m file for 1D P-N model
% ------------------------------------------------------------------------

    % % System name
 
    system='1D P-N model';
 
    % % The absolute path to save the result files
 
    filepath=pwd;
 
    % % The dimension of P-N model: 1 or 2
 
    misdim=1;
 
%% -----------------------------------------------------------------------
% The Parameters for the calculation of dislocation core structure
% ------------------------------------------------------------------------
    
    % % Calculating the dislocation core structure ('TRUE') or NOT ('FALSE')
    
    Dislocation_Core_Structure='TRUE';
    
    % % The data of GSFE (unit: J/m2) and normalized disregistry vector (unit:1)
    
    Ux=[0.00185
0.07003
0.11514
0.1629
0.19495
0.22843
0.25435
0.28252
0.31477
0.33804
0.37009
0.40622
0.43704
0.47194
0.50154
0.5491
0.58646
0.61871
0.64708
0.67668
0.69974
0.72301
0.75139
0.78609
0.8312
0.87366
0.91489
0.94714
0.99858];
    SFE=[-0.00345
0.09557
0.2014
0.34337
0.46596
0.61108
0.74677
0.8856
1.03439
1.14022
1.30262
1.45455
1.56719
1.64944
1.66935
1.61015
1.50747
1.36549
1.2167
1.0742
0.96523
0.86255
0.72058
0.55503
0.35699
0.23126
0.11548
0.04266
-0.00711];
    
    % % Which trial function of disregistry vector to employ (>=1)
    
    Nmis=3;
       
    % % Considering the first-order approximation in the trial function of disregistry
    %   vector (1) or NOT (0)
    
    mis_1st=0;
    
    % % The value of Burgers Vector (unit: A)
 
    BurVect=3.84;
    
    % % The values of shear modulus (unit: GPa) and Poisson's ratio (unit: 1)
 
    shear_modulus=64;
    poisson_ratio=0.0000;
    
    % % The dislocation type: edge ('e') or screw ('s')

    mistype='s';
    
    % % Which GSFE fitting function to employ (>=0)
    
    fitcut=3;
    
    % % Matrix of the lower and upper bounds, and initial values of each unknown 
    %   variable ([Lower bound, Upper bound, StartPoint]) 
    
    Xcoef_range=[  0.0000,  1.0000,  0.1667];
    Xdist_range=[-20.0000, 20.0000,  10.0000];
    Xwid_range =[  0.0000, 10.0000,  0.2000];
    Xalpha_range=[ 0.0000,  2.00000, 1.0000];
    
    % % The mothed for fitting the restoring force: "1d_fitting_toolbox" or "1d_lsq_curvefit"
    
    fitmethod='1d_lsq_curvefit';
    
%% -----------------------------------------------------------------------
% The Parameters for the calculation of Peierls stress
% ------------------------------------------------------------------------
 
    % % Calculating the Peierls stress ('TRUE') or NOT ('FALSE')
    
    Peierls_Stress='TRUE';
 
    % % The method to calculate the Peierls stress: 1 or 2
    
    pnstrmethod=2;
 
    % % Interplanar distance ?x (unit: A) 

    Inpas=3.325538;
    
%% -----------------------------------------------------------------------
% The Parameters for the calculation of pressure field around dislocation core
% ------------------------------------------------------------------------
 
    % % Calculating the pressure field around dislocation core ('TRUE') or NOT ('FALSE')
    
    Pressure_Field='FALSE';
    
    % % The lattice matrix for pressure field
    
    % pressfld_latxz=[];
    % pressfld_latyy=[];
